Game_Player.prototype.updateNonmoving = function (wasMoving) {
    if (!$gameMap.isEventRunning()) {
        if (wasMoving) {
            $gameParty.onPlayerWalk();
            this.checkEventTriggerHere([1, 2]);
            this.checkRegionTrigger();
            if ($gameMap.setupStartingEvent()) {
                return;
            }
        }
        if (this.triggerAction()) {
            return;
        }
        if (wasMoving) {
            this.updateEncounterCount();
        } else {
            $gameTemp.clearDestination();
        }
    }
};

Game_Player.prototype.startMapEvent = function (x, y, triggers, normal) {
    if (!$gameMap.isEventRunning()) {
        $gameMap.eventsActiveXy(x, y).forEach(function (event) {
            if (event.isTriggerIn(triggers) && event.isNormalPriority() === normal) {
                event.start();
            }
        });
    }
};
Game_Player.prototype.checkRegionTrigger = function () {
    if (!$gameMap.isEventRunning()) {
        let regionId = this.regionId() 
        if(regionId==0)
            return
        $gameMap.eventsRegion().forEach(function (event) {
            if (event._regionId == regionId && event._pageIndex!=-1){
                event.start();
            }
        });
    }
};

Game_Map.prototype.eventsActiveXy = function (x, y) {
    return this._eventsActive.filter(function (event) {
        return event.pos(x, y);
    });
};

Game_Map.prototype.eventsRegion = function (x, y) {
    return this._eventsRegion
};

Game_Map.prototype.initialize = function () {
    this._interpreter = new Game_Interpreter();
    this._mapId = 0;
    this._tilesetId = 0;
    this._events = [];
    this._eventsActive=[];
    this._eventsRegion = [];
    this._commonEvents = [];
    this._vehicles = [];
    this._displayX = 0;
    this._displayY = 0;
    this._nameDisplay = true;
    this._scrollDirection = 2;
    this._scrollRest = 0;
    this._scrollSpeed = 4;
    this._parallaxName = '';
    this._parallaxZero = false;
    this._parallaxLoopX = false;
    this._parallaxLoopY = false;
    this._parallaxSx = 0;
    this._parallaxSy = 0;
    this._parallaxX = 0;
    this._parallaxY = 0;
    this._battleback1Name = null;
    this._battleback2Name = null;
    this.createVehicles();
};

Game_Map.prototype.setupEvents = function () {
    this._events = [];
    this._eventsActive = []
    this._eventsRegion = []
    for (var i = 0; i < $dataMap.events.length; i++) {
        if ($dataMap.events[i]) {
            let event = new Game_Event(this._mapId, i)
            this._events[i] = event
            let note=event.event().note
            if (!/<Unactive>/.test(note))
                this._eventsActive.push(event)
            if(/<Region:\d+>/.test(note))
                this._eventsRegion.push(event)
        }
    }
    this._commonEvents = this.parallelCommonEvents().map(function (commonEvent) {
        return new Game_CommonEvent(commonEvent.id);
    });
    this.refreshTileEvents();
};

Game_Event.prototype.setupPage = function () {
    if (this._pageIndex >= 0) {
        this.setupPageSettings();
    } else {
        this.clearPageSettings();
    }
    this.refreshBushDepth();
    this.clearStartingFlag();
    this.checkEventTriggerAuto();
    this.setupRegionID();
};

Game_Event.prototype.setupRegionID=function(){
    var note=this.event().note
    var match = note.match(/<Region:\d+>/)
    if(match){
        this._regionId=parseInt(match[0].slice(8,-1))
    }
}

Game_Event.prototype.initMembers = function () {
    Game_Character.prototype.initMembers.call(this);
    this._moveType = 0;
    this._trigger = 0;
    this._starting = false;
    this._erased = false;
    this._pageIndex = -2;
    this._originalPattern = 1;
    this._originalDirection = 2;
    this._prelockDirection = 0;
    this._locked = false;
    this._regionId = null;
};